/* - LEDAttachListener - 
 * Populate the information fields and initialize the index selector combo boxes
 * according to the number of available LEDs on the connected Phidget LED board.  
 * Enable all the editable controls.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.LEDPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.AttachListener;
import com.phidgets.event.AttachEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class LEDAttachListener implements AttachListener{
    
    private JFrame appFrame;
    private JTextField attachedTxt;
    private JTextArea nameTxt;
    private JTextField serialTxt;
    private JTextField versionTxt;
    private JTextField numLEDTxt;
    private JComboBox ledCmb;
    private JSlider ledBrightScrl;
    private JComboBox voltageCmb;
    private JComboBox currentLimitCmb;
    private JLabel voltageLbl;
    private JLabel currentLimitLbl;
    
    /** Creates a new instance of LEDAttachListener */
    public LEDAttachListener(JFrame appFrame, JTextField attachedTxt, JTextArea nameTxt,
            JTextField serialTxt, JTextField versionTxt, JTextField numLEDTxt, 
            JComboBox ledCmb, JSlider ledBrightScrl, JComboBox voltageCmb, 
            JComboBox currentLimitCmb, JLabel voltageLbl, JLabel currentLimitLbl)
    {
        this.appFrame = appFrame;
        this.attachedTxt = attachedTxt;
        this.nameTxt = nameTxt;
        this.serialTxt = serialTxt;
        this.versionTxt = versionTxt;
        this.numLEDTxt = numLEDTxt;
        this.ledCmb = ledCmb;
        this.ledBrightScrl = ledBrightScrl;
        this.voltageCmb = voltageCmb;
        this.currentLimitCmb = currentLimitCmb;
        this.voltageLbl = voltageLbl;
        this.currentLimitLbl = currentLimitLbl;
    }

    public void attached(AttachEvent ae)
    {
        try
        {
            LEDPhidget attached = (LEDPhidget)ae.getSource();
            attachedTxt.setText(Boolean.toString(attached.isAttached()));
            nameTxt.setText(attached.getDeviceName());
            serialTxt.setText(Integer.toString(attached.getSerialNumber()));
            versionTxt.setText(Integer.toString(attached.getDeviceVersion()));
            numLEDTxt.setText(Integer.toString(attached.getLEDCount()));
            
            for(int i = 0; i < attached.getLEDCount(); i++)
            {
                ledCmb.addItem(new Integer(i));
            }
            
            ledCmb.setSelectedIndex(0);
            ledCmb.setEnabled(true);
            ledBrightScrl.setValue(0);
            ledBrightScrl.setEnabled(true);
            
            try
            {
                int voltage = attached.getVoltage();
                switch(voltage)
                {
                    case 1:
                        voltageCmb.setSelectedItem("1.7V");
                        break;
                    case 2:
                        voltageCmb.setSelectedItem("2.75V");
                        break;
                    case 3:
                        voltageCmb.setSelectedItem("3.9V");
                        break;
                    case 4:
                        voltageCmb.setSelectedItem("5.0V");
                        break;
                }
                voltageLbl.setVisible(true);
                voltageCmb.setEnabled(true);
                voltageCmb.setVisible(true);
            }
            catch (PhidgetException ex1)
            {
                voltageLbl.setVisible(false);
                voltageCmb.setEnabled(false);
                voltageCmb.setVisible(false);
            }
            
            try
            {
                int currentLimit = attached.getCurrentLimit();
                switch(currentLimit)
                {
                    case 1:
                        currentLimitCmb.setSelectedItem("20mA");
                        break;
                    case 2:
                        currentLimitCmb.setSelectedItem("40mA");
                        break;
                    case 3:
                        currentLimitCmb.setSelectedItem("60mA");
                        break;
                    case 4:
                        currentLimitCmb.setSelectedItem("80mA");
                        break;
                }
                currentLimitLbl.setVisible(true);
                currentLimitCmb.setEnabled(true);
                currentLimitCmb.setVisible(true);
            }
            catch (PhidgetException ex2)
            {
                currentLimitLbl.setVisible(false);
                currentLimitCmb.setEnabled(false);
                currentLimitCmb.setVisible(false);
            }
        }
        catch (PhidgetException ex)
        {
            JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }
    
}